<?php
/*--------------------------------------------------------------
   Predefined.php 2021-07-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option;

use Gambio\Admin\Modules\Statistics\App\Overview\Factory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\MaxEntriesDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\TimespanDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown;

class Predefined
{
    /**
     * Return time span dropdown.
     */
    public function createTimespanDropdown(Factory $factory): Dropdown
    {
        return TimespanDropdown::create($factory);
    }
    
    
    /**
     * Return time span dropdown including today.
     */
    public function createTimespanDropdownIncludingToday(Factory $factory): Dropdown
    {
        return TimespanDropdown::createIncludingToday($factory);
    }
    
    
    /**
     * Return maximum entries dropdown.
     */
    public function createMaxEntriesDropdown(Factory $factory): Dropdown
    {
        return MaxEntriesDropdown::create($factory);
    }
}